define([
    'underscore',
    'models/singleton-model',
    'Vent',
    'jwt_decode',
],
function(_, Model, vent, jwtDecode) {
    'use strict';

    var UserSession = Model.extend({
        resourceName: 'public-user-session',

        initialize: function(options) {
            this.jwtTokenUrl = options.jwtTokenUrl;
        },
        isLoggedIn: function() {
            return this.get('authenticated');
        },
        startSessionTimer: function() {
            this._sessionTimer();
            this._sessionTimer = _.noop;
        },
        _sessionTimer: function() {
            var self = this;
            var oneSecond = 1000;
            var oneMinute = 60000;
            var twoMinutes = 120000;
            var threeMinutes = 180000;
            var timeToExpire = 0;
            var countdownTimer;
            var waitTime;
            var sessionEnded = false;

            function checksession() {
                var encodedJwtToken = getCookie('DNS      ');
                var jwtCookie;

                if (encodedJwtToken === null) {
                    vent.trigger('show:session:expired');
                    return;
                }

                jwtCookie = jwtDecode(encodedJwtToken);
                timeToExpire = (jwtCookie.exp * oneSecond) - new Date().getTime();

                if (timeToExpire <= threeMinutes) {
                    showTimeoutModal(timeToExpire);
                }
                waitTime = timeToNearestMinute(timeToExpire);

                if (!sessionEnded) {
                    clearTimeout(countdownTimer);
                    countdownTimer = setTimeout(function() {
                        checksession();
                    }, waitTime);
                } else {
                    vent.trigger('show:session:expired');
                }
            }

            // Taken from: https://www.w3schools.com/js/js_cookies.asp
            function getCookie(cname) {
                var name = cname + '=';
                var decodedCookie = decodeURIComponent(document.cookie);
                var ca = decodedCookie.split(';');
                var i;
                var c;

                for (i = 0; i < ca.length; i++) {
                    c = ca[i];
                    while (c.charAt(0) === ' ') {
                        c = c.substring(1);
                    }
                    if (c.indexOf(name) === 0) {
                        return c.substring(name.length, c.length);
                    }
                }
                return null;
            }

            function timeToNearestMinute(_timeToExpire) {
                if (_timeToExpire > threeMinutes) {
                    return _timeToExpire - threeMinutes;
                } else if (_timeToExpire > twoMinutes) {
                    return _timeToExpire - twoMinutes;
                } else if (_timeToExpire > oneMinute) {
                    return _timeToExpire - oneMinute;
                }

                return _timeToExpire;

            }

            function showTimeoutModal(_timeToExpire) {
                var minutesToExpire = Math.round(parseInt(_timeToExpire, 10) / oneMinute);

                if (minutesToExpire <= 0) {
                    sessionEnded = true;
                    vent.trigger('show:session:expired');
                } else {
                    self.set('sessionTimeoutIn', 'Your user session will time out in ' +
                        minutesToExpire + ' minute' + (minutesToExpire > 1 ? 's.' : '.'));
                    vent.trigger('show:session:warning');
                }
            }


            checksession();
        },
    });
    return UserSession;
});
